<?php

namespace App\Http\Controllers;

use App\Deposit;
use App\ExchangeMoney;
use App\Gateway;
use App\Post;
use App\Referral;
use App\Subscriber;
use App\User;
use App\WithdrawLog;


use Illuminate\Http\Request;
use Auth;
use App\GeneralSettings;

class AdminController extends Controller
{

	public function __construct(){
		$Gset = GeneralSettings::first();
		$this->sitename = $Gset->sitename;
	}

	public function dashboard()
    {
        $data['page_title'] = 'DashBoard';

        $data['totalUsers'] = User::count();
        $data['banUsers'] = User::where('status',0)->count();
        $data['phone_verify'] = User::where('phone_verify',1)->count();
        $data['email_verify'] = User::where('email_verify',1)->count();
        $data['gateway'] = Gateway::count();
        $data['deposit'] = Deposit::where('status',1)->count();

        $data['subscriber'] = Subscriber::count('id');

        $data['withdrawReq'] = WithdrawLog::whereStatus(1)->count();
        $data['withdrawSuc'] = WithdrawLog::whereStatus(2)->count();
        $data['withdrawRefund'] = WithdrawLog::whereStatus(-2)->count();

        /*
         * Exchange
         */

        $data['exchangePending'] = ExchangeMoney::whereStatus(1)->count();
        $data['exchangeSucc'] = ExchangeMoney::whereStatus(2)->count();
        $data['exchangeCan'] = ExchangeMoney::whereStatus(-1)->count();
        $data['exchangeRefund'] = ExchangeMoney::whereStatus(-2)->count();


        $data['blog'] = Post::count();
        $data['Gset'] = GeneralSettings::first();
        return view('admin.dashboard', $data);
    }


    public function refIndex()
    {
        $page_title = 'Manage Referral';
        $trans = Referral::get();
        return view('admin.refer',compact('page_title', 'trans'));

    }
    public function refStore(Request $request)
    {
        $this->validate($request, [
            'level*' => 'required|integer|min:1',
            'percent*' => 'required|numeric',
        ]);

        Referral::truncate();

        for ($a = 0; $a < count($request->level); $a++){
            Referral::create([
                'level' => $request->level[$a],
                'percent' => $request->percent[$a],
                'status' => 1,
            ]);
        }

        return back()->with('message', 'Create Successfully');

    }






	public function logout()    {
		Auth::guard('admin')->logout();
		session()->flash('success', 'You have been logged out!!');
		return redirect('/admin');
	}

}
